//
//  ContentView.swift
//  MyOkashi
//
//  Created by Swift-Beginners.
//

import SwiftUI

struct ContentView: View {
    @State var inputText = ""
    @State var okashiDataList = OkashiData()

    // 2列グリッド定義
    let columns = [GridItem(.flexible(), spacing: 16), GridItem(.flexible())]

    var body: some View {
        VStack(alignment: .leading) {
            // 検索バー
            HStack {
                Image(systemName: "magnifyingglass")
                    .foregroundColor(.gray)
                TextField("お菓子を検索", text: $inputText, prompt: Text("お菓子を検索"))
                    .textFieldStyle(.plain)
                    .padding(.vertical, 8)
                    .padding(.horizontal, 4)
                    .onSubmit {
                        okashiDataList.searchOkashi(keyword: inputText)
                    }
                Spacer(minLength: 8)
                Button(action: {
                    okashiDataList.searchOkashi(keyword: inputText)
                }) {
                    Text("検索")
                        .foregroundColor(.blue)
                        .fontWeight(.medium)
                }
            }
            .padding(.horizontal)
            .padding(.top, 16)
            .padding(.bottom, 8)

            // 検索結果件数
            HStack {
                Spacer()
                Text("検索結果：\(okashiDataList.okashiList.count)件")
                    .font(.footnote)
                    .foregroundColor(.gray)
                    .padding(.trailing)
            }

            // グリッド表示
            ScrollView {
                LazyVGrid(columns: columns, spacing: 20) {
                    ForEach(okashiDataList.okashiList) { okashi in
                        VStack(spacing: 12) {
                            AsyncImage(url: okashi.image) { image in
                                image.resizable()
                                    .scaledToFit()
                                    .frame(height: 100)
                                    .cornerRadius(20)
                            } placeholder: {
                                RoundedRectangle(cornerRadius: 20)
                                    .fill(Color(white: 0.9))
                                    .frame(height: 100)
                                    .overlay(
                                        Text("お菓子の画像")
                                            .foregroundColor(.black.opacity(0.6))
                                            .font(.caption)
                                    )
                            }
                            Text(okashi.name)
                                .font(.headline)
                                .foregroundColor(.blue)
                                .multilineTextAlignment(.center)
                        }
                        .frame(maxWidth: .infinity, minHeight: 200)
                        .background(Color.white)
                        .cornerRadius(24)
                        .shadow(color: Color.black.opacity(0.04), radius: 2, x: 0, y: 1)
                        .padding(4)
                    }
                }
                .padding([.horizontal, .bottom])
            }
            .background(Color(white: 0.97))
        }
        .background(Color(white: 0.97).ignoresSafeArea())
    }
}

// プレビュー描画
#Preview {
    ContentView()
}
