//
//  ContentView.swift
//  MyJanken
//
//  Created by Swift-Beginners.
//

import SwiftUI

struct ContentView: View {
    @State var omikujiResult = "おみくじを引く"

    var body: some View {
        VStack {
            Spacer()
            Text(omikujiResult)
                .font(.largeTitle)
                .padding(.top, 60)
            Spacer()
            Button {
                let results = ["大吉", "中吉", "小吉", "吉"]
                omikujiResult = results.randomElement()!
            } label: {
                Text("おみくじを引く")
                    .frame(maxWidth: .infinity)
                    .frame(height: 80)
                    .font(.title)
                    .background(.pink)
                    .foregroundStyle(.white)
                    .cornerRadius(16)
                    .padding(.horizontal)
            }
            Spacer(minLength: 40)
        }
    }
}

// プレビュー描画
#Preview {
    ContentView()
} // プレビュー ここまで
